set sql_safe_updates=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_BIRTHDAY_GREETING_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="select ID,BIRTH_DATE,SALUTATION_NAME,FIRST_NAME,MIDDLE_NAME,LAST_NAME,EMAIL_ID,MOBILE_NO,MOBILE_CODE,group_concat(DEVICE_ID) AS DEVICE_ID from
(
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as LAST_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
        f.deviceTokenId AS DEVICE_ID
	from 
		students s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
        LEFT JOIN fire_base_persons_info f ON f.userId = s.userId
	UNION
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as MIDDLE_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
        f.deviceTokenId AS DEVICE_ID
	from 
		staffs s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
		LEFT JOIN fire_base_persons_info f ON f.userId = u.id
) as PSEUDO
 where date_format(BIRTH_DATE,'%m-%d') = date_format(now(),'%m-%d')
and id in (namedParams) group by id" WHERE dataProviderId=@dtproviderId;
        
        
SET @timeTable=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_CHANGE_RECIPIENT_INFO');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'select T1.userId as ID,
	T2.`firstName` AS FIRST_NAME,
	T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
	T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    group_concat(distinct f.deviceTokenId) AS DEVICE_ID
 from students T1
	left join persons T2 on T1.personId=T2.id
     LEFT JOIN fire_base_persons_info f ON f.userId = T1.userId
    where T1.userId in (namedParams)
    group by T1.userId'
WHERE
    `dataProviderId`=@timeTable;
    
    
SET @resetPawrd=(SELECT id FROM dtprovider WHERE `dataProviderName`='RESET_PASSWORD_RECIPIENT');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    group_concat(distinct f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1
        LEFT JOIN
    `students` T4 ON T4.`userId` = T1.`id`
        LEFT JOIN
    `staffs` T5 ON T5.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
        OR T2.`id` = T5.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
WHERE
    T4.userId IN (namedParams)
        OR T5.userId IN (namedParams) group by T1.id'
WHERE
    `dataProviderId`=@resetPawrd;
    
    
SET @eventParticipant=(SELECT id FROM dtprovider WHERE `dataProviderName`='Resource Participant Recipient');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
WHERE
    T1.id IN (namedParams) group by T1.id

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`students` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
WHERE
    T1.id IN (namedParams) group by T1.id

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`parents` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
WHERE
    T1.id IN (namedParams) group by T1.id'
WHERE
    `dataProviderId`=@eventParticipant;

SET @dailyAbsent=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_STUDENT_MARKED_ABSENT_FOR_THE_SESSION_RCPNT');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    scad.id AS ID,
    T1.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.emailId AS EMAIL_ID,
    T7.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T8.displayName AS ACADEMY_NAME,
    T9.salutationName AS SALUTATION_NAME,
    DATE_FORMAT(sca.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(sca.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(sca.toTime, '%h:%i %p') AS SLOT_TO,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    student_course_attendance sca
        LEFT JOIN
    student_course_attendance_details scad ON sca.id = scad.attendanceId
        LEFT JOIN
    course_variants T1 ON T1.id = sca.variantId
        LEFT JOIN
    admission T5 ON T5.id = scad.admissionId
        LEFT JOIN
    students T6 ON T6.userId = T5.studentId
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    salutations T9 ON T9.id = T7.salutationId
        LEFT JOIN
    academy_location T8 ON T8.id = sca.academyLocationId
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T6.userId
WHERE
    scad.attendanceStatus = 'ABSENT'
        AND scad.id IN (namedParams) group by scad.id"
WHERE
    `dataProviderId`=@dailyAbsent;
    
    
SET @dayAbsent=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_STUDENT_MARKED_ABSENT_FOR_THE_DAY_RCPNT');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT     
    T2.id AS ID,
	T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.emailId AS EMAIL_ID,
	T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
	T6.displayName AS ACADEMY_NAME,    
    DATE_FORMAT(T1.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    student_program_attendance T1
        LEFT JOIN
    student_program_attendance_details T2 ON T2.attendanceId = T1.id
        LEFT JOIN
    admission T3 ON T3.id = T2.admissionId
		LEFT JOIN
    students T4 ON T4.userId = T3.studentId
		LEFT JOIN
    persons T5 ON T5.id = T4.personId
		LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
    
WHERE
	T2.attendanceStatus = 'ABSENT'
	AND T2.id IN (namedParams) group by T2.id"
WHERE
    `dataProviderId`=@dayAbsent;
    
    
SET @updateAttendance=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_DAY_WISE_STUDENT_RCPNT');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
    T2.id AS ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.displayName AS ACADEMY_NAME,
    DATE_FORMAT(T1.dateOfAttendance, "%d-%m-%Y") AS SESSION_DATE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    (CASE
        WHEN
            (T9.itemValue = T9.attendanceStatus)
        THEN
            CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                    LCASE(SUBSTRING(T9.attendanceStatus, 2)))
        ELSE CONCAT(T9.itemValue,
                "/",
                CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                        LCASE(SUBSTRING(T9.attendanceStatus, 2))))
    END) AS ATTENDANCE_STATUS,
    T8.printName AS FACULTY_PRINT_NAME,
    DATE_FORMAT(DATE(NOW()), "%d-%m-%Y") AS TODAY_DATE
FROM
    student_program_attendance T1
        LEFT JOIN
    student_program_attendance_details T2 ON T2.attendanceId = T1.id
        LEFT JOIN
    admission T3 ON T3.id = T2.admissionId
        LEFT JOIN
    students T4 ON T4.userId = T3.studentId
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    staffs T7 ON T7.userId = T2.lastUpdatedBy
        LEFT JOIN
    persons T8 ON T8.id = T7.personId
        LEFT JOIN
    attendance_marking_type AS T9 ON T9.id = T2.attendanceMarkingTypeId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
WHERE
    T2.id IN (namedParams) group by T2.id'
WHERE
    `dataProviderId`=@updateAttendance;
    
    
    
SET @updateSessionwise=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_SESSION_WISE_STUDENT_RCPNT');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
    T2.id AS ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.displayName AS ACADEMY_NAME,
    DATE_FORMAT(T1.dateOfAttendance, "%d-%m-%Y") AS SESSION_DATE,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    T1.sessionNo AS SESSION_NUMBER,
    (CASE
        WHEN
            (T9.itemValue = T9.attendanceStatus)
        THEN
            CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                    LCASE(SUBSTRING(T9.attendanceStatus, 2)))
        ELSE CONCAT(T9.itemValue,
                "/",
                CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                        LCASE(SUBSTRING(T9.attendanceStatus, 2))))
    END) AS ATTENDANCE_STATUS,
    T8.printName AS FACULTY_PRINT_NAME,
    DATE_FORMAT(DATE(NOW()), "%d-%m-%Y") AS TODAY_DATE
FROM
    student_program_attendance T1
        LEFT JOIN
    student_program_attendance_details T2 ON T2.attendanceId = T1.id
        LEFT JOIN
    admission T3 ON T3.id = T2.admissionId
        LEFT JOIN
    students T4 ON T4.userId = T3.studentId
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    staffs T7 ON T7.userId = T2.lastUpdatedBy
        LEFT JOIN
    persons T8 ON T8.id = T7.personId
        LEFT JOIN
    attendance_marking_type AS T9 ON T9.id = T2.attendanceMarkingTypeId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
WHERE
    T2.id IN (namedParams) group by T2.id'
WHERE
    `dataProviderId`=@updateSessionwise;
    

    
    
SET @updateCoursewise=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_COURSE_WISE_STUDENT_RCPNT');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    scad.id AS ID,
    T1.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T8.displayName AS ACADEMY_NAME,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    DATE_FORMAT(sca.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(sca.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(sca.toTime, '%h:%i %p') AS SLOT_TO,
    (CASE
        WHEN
            (T9.itemValue = T9.attendanceStatus)
        THEN
            CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                    LCASE(SUBSTRING(T9.attendanceStatus, 2)))
        ELSE CONCAT(T9.itemValue,
                '/',
                CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                        LCASE(SUBSTRING(T9.attendanceStatus, 2))))
    END) AS ATTENDANCE_STATUS,
    T11.printName AS FACULTY_PRINT_NAME,
    DATE_FORMAT(DATE(NOW()), '%d-%m-%Y') AS TODAY_DATE
FROM
    student_course_attendance sca
        LEFT JOIN
    student_course_attendance_details scad ON sca.id = scad.attendanceId
        LEFT JOIN
    course_variants T1 ON T1.id = sca.variantId
        LEFT JOIN
    admission T5 ON T5.id = scad.admissionId
        LEFT JOIN
    students T6 ON T6.userId = T5.studentId
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    academy_location T8 ON T8.id = sca.academyLocationId
        LEFT JOIN
    staffs T10 ON T10.userId = scad.lastUpdatedBy
        LEFT JOIN
    persons T11 ON T11.id = T10.personId
        LEFT JOIN
    attendance_marking_type AS T9 ON T9.id = scad.attendanceMarkingTypeId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T6.userId
WHERE
    scad.id IN (namedParams) group by scad.id"
WHERE
    `dataProviderId`=@updateCoursewise;


        
        
set sql_safe_updates=1;